---
name: creating-sdd-directory
description: Initialize structured directory for specification driven development (SDD) based on user requirement descriptions, when user first chats with spec-agent.
allowed-tools: Read, Write, Edit, Glob, Grep, Bash, BashOutput
---


# creating sdd directory

## Purpose
This skill creates a directory structure for software requirement, design, and tasks documentation directly from natural language requirement descriptions provided by users in the chat interface, ensuring consistent naming, proper timestamping, and valid directory creation following predefined rules.

## Core Workflow
### 1. Prerequisite Context
The skill is triggered when a user first inputs a requirement description in the chat window with spec-agent, must not be used without spec-agent or there is already existing matched directory.

### 2. Base Directory Validation & Creation
Verify the existence and state of the core specifications directory (`.codeartsdoer/specs/`). If the directory does not exist or is empty, initialize it to serve as the root for all feature-specific SDD files.

### 3. Feature Name Generation
Process the user's requirement description to generate a concise `feature_name` identifier that complies with the following strict constraints:
- Maximum length: 10 characters
- Allowed characters: lowercase English letters (a-z), numbers (0-9), underscores (_)
- No spaces, uppercase letters, special characters, or symbols
- Example valid names: "user_login", "data_sync", "api_v3"

### 4. Feature-Specific Directory Creation
Construct the full directory path using the generated identifiers: `.codeartsdoer/specs/{feature_name}`. Validate if this directory exists or is empty; if not present, create it to store all SDD artifacts related to the specified feature.

## Tool Capabilities (Background Execution)
This skill leverages file operation capabilities to execute the workflow, including:
- Directory existence checks and content verification
- Creation of new directories at specified paths
- Compliance validation for feature name formatting
- Timestamp generation and path construction
- File system navigation and validation

## Example Execution
**User Input**: "Implement secure password reset for user accounts"
**Step 1**: Confirm `.codeartsdoer/specs/` exists (create if missing)
**Step 2**: Generate `feature_name`: "password_reset"
**Step 3**: Create directory: `.codeartsdoer/specs/password_reset/`
**Outcome**: A dedicated, uniquely named directory is ready for SDD authoring aligned with the user's password reset requirement.